﻿init python:
    
    class Execute(Action):
        """
        Well... it executes... :)
        This has NOTHING to do with calendar, just makes using it with screen language easier.
        """
        def __init__(self, func, *args, **kwargs):
            self.func = func
            self.args = args
            self.kwargs = kwargs
        
        def __call__(self):
            self.func(*self.args, **self.kwargs)
            return False
            
    class ProportionalScale(im.ImageBase):
        '''Resizes a renpy image to fit into the specified width and height.
        The aspect ratio of the image will be conserved.'''
        def __init__(self, imgname, maxwidth, maxheight, bilinear=True, **properties):
            img = im.image(imgname)
            super(ProportionalScale, self).__init__(img, maxwidth, maxheight, bilinear, **properties)
            self.imgname = imgname
            self.image = img
            self.maxwidth = int(maxwidth)
            self.maxheight = int(maxheight)
            self.bilinear = bilinear

        def load(self):
            child = im.cache.get(self.image)
            width, height = child.get_size()
            
            ratio = min(self.maxwidth/float(width), self.maxheight/float(height))
            width = ratio * width
            height = ratio * height

            if self.bilinear:
                try:
                    renpy.display.render.blit_lock.acquire()
                    rv = renpy.display.scale.smoothscale(child, (width, height))
                finally:
                    renpy.display.render.blit_lock.release()
            else:
                try:
                    renpy.display.render.blit_lock.acquire()
                    rv = renpy.display.pgrender.transform_scale(child, (newwidth, newheight))
                finally:
                    renpy.display.render.blit_lock.release()
            return rv

        def predict_files(self):
            return self.image.predict_files()
    
    class Calendar(object):
        '''Provides time-related information.
        Most class methods take a daycount parameter, which is assumed to be a count
        of passed days, starting with 1 for the first day.
        newmoonday is the daycount of the first new moon, e.g. 1 for the first
        day.
        Cheers to Rudi for mooncalendar calculations.
        '''
        def __init__(self, day=1, month=1, year=1, leapyear=False):
            """
            Expects day/month/year as they are numbered in normal calender.
            If you wish to add leapyear, specify a number of the first Leap year to come.
            """
            self.day = day
            self.month = month - 1
            self.year = year
            if not leapyear:
                self.leapyear = self.year + 4
            else:    
                self.leapyear = leapyear
            
            self.daycount_from_gamestart = 0
            
            self.days = ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"]
            self.month_names = ['January', 'February', 'March', 'April', 'May', 'June', 'July',
                                               'August', 'September', 'October', 'November', 'December']
            self.days_count = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31]
            
            self.mooncycle = 29
            self.newmoonday = 1
            
        def game_day(self):
            """
            Returns amount of days player has spent in game.
            Counts first day as day 1.
            """
            return self.daycount_from_gamestart + 1
            
        def string(self):
            return "(%s) - %s %d %d"%(self.weekday(), self.month_names[self.month], self.day, self.year)
            
        def next(self, days=1):
            """
            Next day counter.
            Now supports skipping.
            """
            self.daycount_from_gamestart += days
            while days:
                self.day += 1
                days -= 1
                if self.leapyear == self.year and self.month == 1:
                    if self.day > self.days_count[self.month] + 1:
                        self.month += 1
                        self.day = 1
                        self.leapyear += 4
                elif self.day > self.days_count[self.month]:
                    self.month += 1
                    self.day = 1
                    if self.month > 11: 
                        self.month = 0
                        self.year += 1
                        

        def weekday(self):
            '''Returns the name of the current day according to daycount.'''
            daylistidx = self.daycount_from_gamestart % len(self.days)
            return self.days[daylistidx]

        def week(self):
            '''Returns the number of weeks, starting at 1 for the first week.
            '''
            weekidx = self.daycount_from_gamestart / len(self.days)
            return weekidx + 1

        def lunarprogress(self):
            '''Returns the progress in the lunar cycle since new moon as percentage.
            '''
            newmoonidx = self.newmoonday - 1
            dayidx = self.daycount_from_gamestart - newmoonidx
            moonidx = dayidx % self.mooncycle
            moondays = moonidx + 1
            percentage = moondays * 100.0 / self.mooncycle
            return int(round(percentage))

        def moonphase(self):
            '''Returns the lunar phase according to daycount.

            Phases:
            new moon -> waxing crescent -> first quater -> waxing moon ->
                full moon -> waning moon -> last quarter -> waning crescent -> ...
            '''
            # calculate days into the cycle
            newmoonidx = self.newmoonday - 1
            dayidx = self.daycount_from_gamestart - newmoonidx
            moonidx = dayidx % self.mooncycle
            moondays = moonidx + 1
            # substract the number of named days
            unnamed_days = self.mooncycle - 4
            # calculate the days per quarter
            quarter = unnamed_days / 4.0
            # determine phase
            if moonidx<1:
                phase = "new moon"
            elif moonidx<(quarter+1):
                phase = "waxing crescent"
            elif moonidx<(quarter+2):
                phase = "first quarter"
            elif moonidx<(2*quarter+2):
                phase = "waxing moon"
            elif moonidx<(2*quarter+3):
                phase = "full moon"
            elif moonidx<(3*quarter+3):
                phase = "waning moon"
            elif moonidx<(3*quarter+4):
                phase = "last quarter"
            else:
                phase = "waning crescent"
            return phase

            
screen calendar_testing:
    vbox:
        xminimum 500
        xfill True
        spacing 10
        align(0.5, 0.1)
        text "Day: %d"%calendar.game_day()
        text "Week: %d"%calendar.week()
        text "Date: %s"%calendar.string()
        text "Next Leap Year: %s"%calendar.leapyear
        text "Lunar Progress: %d%%"%calendar.lunarprogress()
        text "Moon Phase: %s"%calendar.moonphase().capitalize()
        
    hbox:
        spacing 10
        align (0.5, 0.7)
        textbutton "+1 Day":
            action Execute(calendar.next, 1)
        textbutton "+1 Week":
            action Execute(calendar.next, 7)
        textbutton "+100 Days":
            action Execute(calendar.next, 100)
            
label start:
    $ calendar = Calendar(5, 2, 2014, 2016) # Calendar(day, month, year, first leap year (can be ignored))
    # $ calendar.next() <--- This will cause your calendar to advance by one day.
    # $ calendar.next(days=7) <--- By one week, if one turn of your game is a week.
    
    show screen calendar_testing
    
    while True: # This has nothing to do with calendar, just to make sure that we can toy with it without leaving the game.
        $ result = ui.interact()

